/*******************************************************************************
* File Name          : lcd.c
* Author             : 
* Date First Issued  : 14/07/2003
* Description        : 
*******************************************************************************/
#include "lcd.h"
#include "gpio.h"
#include "emi.h"
#include <unistd.h>
#include <linux/delay.h>
#include <asm/param.h>



typedef volatile struct
{
  u8 X;
  u8 Y;
} CursorPosition_TypeDef;

      
CursorPosition_TypeDef CursorPosition;

#define LCD_EMI_BANK  EMI_BANK2

/*******************************************************************************
* Function Name  : LCD_Delay
* Description    : 
* Input          : Delay factor
* Output         : 
* Return         : 
*******************************************************************************/

void LCD_Delay (u16 Factor1)
{
 u32 i;
 Factor1 =Factor1*100;
 usleep(Factor1);   
}
/*******************************************************************************
* Function Name  : LCD_Command
* Description    : Send a commend to the LCD
* Input          : Command
* Output         : None
* Return         : None
*******************************************************************************/
static void LCD_Command ( u8 command )
{
  *(u8 *)(LCD_EMI_BANK) = command;
  //wait
  LCD_Delay (1);
}
/*******************************************************************************
* Function Name  : LCD_UnderlineCursorOff
* Description    : The cursor disappears.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void LCD_UnderlineCursorOff(void)
{
  LCD_Command (0x0C);
}
/*******************************************************************************
* Function Name  : LCD_Init
* Description    : Initialize the LCD screen
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void LCD_Init(void)
{
  GPIO_Config (GPIO2, 0x0004, GPIO_AF_PP);
  EMI_Config ( 2, EMI_ENABLE | EMI_WAITSTATE (0xA) | EMI_SIZE_8 );

  //wait for 15 ms
  LCD_Delay (150);
  //function set
  LCD_Command (0x38);

  //wait for 4.1 ms
  LCD_Delay (41);  
  //function set 
  LCD_Command (0x38);

  //wait for 100 us
  LCD_Delay (2);
  //function set 
  LCD_Command (0x38);
 
  //function set, 8 bits long, 2 display lines, 5x8 dots display font type
  LCD_Command (0x38);
  //wait 1.6ms
  LCD_Delay (16);
 
  //display off 
  LCD_Command (0x08);
  //wait 1.6ms
  LCD_Delay (16);
 
  //display clear 
  LCD_Command (0x01);
  //wait 1.6ms  
  LCD_Delay (16);
  //entry mode set, assign cursor moving direction and disable the shift of entire display 
  LCD_Command (0x06);        
  //wait 1.6ms
  LCD_Delay (16);
}

/*******************************************************************************
* Function Name  : LCD_SetCursorPosition
* Description    : Position the LCD cursor at a desired row and column.
* Input          : Col, Row
* Output         : None
* Return         : None
*******************************************************************************/
void LCD_SetCursorPosition(u8 col, u8 row)
{
  CursorPosition.X=col;
  CursorPosition.Y=row;
  switch (row) {
    case 1: LCD_Command (0x80 + col - 1); LCD_Delay (10); break;
    case 2: LCD_Command (0xc0 + col - 1); LCD_Delay (10); break;
    default: break;
  }
}

/*******************************************************************************
* Function Name  : LCD_Data
* Description    : 
* Input          : Data
* Output         : None
* Return         : None
*******************************************************************************/
static void LCD_Data ( u8 data )
{
  *(u8 *)(LCD_EMI_BANK + 4) = data;
  //wait
  LCD_Delay (1);
}
/*******************************************************************************
* Function Name  : LCD_DisplayCharacter
* Description    : Display a character at a given position.
* Input          : 
* Output         : 
* Return         : 
*******************************************************************************/
void LCD_DisplayCharacter (u8 c, u8 col, u8 row)
{
  LCD_SetCursorPosition(col, row);
  LCD_Data (c);
  //wait 1.6ms
  LCD_Delay (1);
}

/*******************************************************************************
* Function Name  : LCD_String
* Description    : Display a string at a given position
* Input          : 
* Output         : 
* Return         : 
*******************************************************************************/
void LCD_String(char *String, u8 col, u8 row)
{
  int i;
  for (i=0; String[i] != '\0'; i++)
    LCD_DisplayCharacter(String[i], col+i, row);
}


/*******************************************************************************/
